* To be run on PC

version 10
clear
program drop _all
set mem 100m
set matsize 800
set more off

* Getting sales & estate tax rate data together for merge
cd "C:\Users\Andrew\State & local tax progressivity\" 
for any sales_tax inheritance_tax estate_tax: use state_X_rates, clear \ renpfix _ X \ reshape long X, i(state) j(year) \ replace X=X/100 \ keep if year>=1977 \ sort state year \ save temp_X, replace
gen estate_tax_dummy=1 if estate_tax>0 & estate_tax~=.
ren estate_tax inheritance_tax
recode i 0=.
merge state year using temp_inheritance_tax, update
recode i .=0
recode estate_tax_dummy .=0
drop _merge
sort state year
merge state year using temp_sales_tax
drop _merge
ren state statename
replace statename="D.C." if statename=="District of Columbia"
sort statename
merge statename using statename_2letter_xwalk
tab _merge
drop _merge
sort stcode year
save temp_other_state_taxes, replace
for any sales_tax inheritance_tax estate_tax: erase temp_X.dta

use state_unionmembership, clear
reshape long unionization, i(stcps) j(year)
replace unionization=unionization/100
ren stcps state
sort state year
save temp_unionization, replace

* Calculating mean and median earnings by year
* This is a little routine that creates faminc_meanmedian, which is used by stateineq_nber
*for num 1977/2002: use temp_posttaxX, clear \ collapse (median) faminc_median=faminc (mean) faminc_mean=faminc [aw=wgt], by(state) \ gen year=X \ sort state year \ save tempmmX, replace
*use tempmm1977, clear
*for num 1978/2002: merge state year using tempmmX \ drop _merge \ sort state year
*ren state stcps
*decode stcps, gen(stcode)
*gen state:"State SOI"=.
*for @ in any AL AK AZ AR CA CO CT DE DC FL GA HI ID IL IN IA KS KY LA ME MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND OH OK OR PA RI SC SD TN TX UT VT VA WA WV WI WY \ # in num 1/51: replace state=# if stcode=="@" 
*drop stcode
*sort state year
*save faminc_meanmedian, replace
*for num 1977/2002: erase tempmmX.dta
*For 2003, I use data from BEA, which shows that pers inc per capita went from $30,913 in 2002 to $31,633 in 2003 (http://www.bea.gov/bea/dn/nipaweb/SelectTable.asp?Selected=N#S7, Table 7.1)

***********************************************************
* Looking at the number of top-coded hourly wages
***********************************************************
for Y in num 1977/2002 \ X in num 17607.04 19262.67 21217.16 22623.83 24542.5 25884.16 26885.94 29240.22 30658.91 32368.86 33844.87 35602.16 37764.64 38640.56 39202.21 40243.89 41241.48 43098.48 47464.73 49595.78 52432.28 54749.87 56630.34 60715.47 64232.86 64150.74: use cps_posttaxY.dta, clear \ gen wagehr=_incwag/(hrslyr*_wkslyr) \ gen trunc=1 if wagehr>(X/65644)*500 & wagehr~=. \ sum trunc

***********************************************************
* These next lines take the simulated tax progressivity indices, created by stateineq_setup1
* and the actual inequality figures, from stateineq_setup2. We then combine them. 
* (Note that we have 2 year variables, cpsyear, and earnings year=cpsyear-1)
***********************************************************

* Putting the files together
use tempineq90sim1977, clear
for num 1978/2002: merge year using tempineq90simX \ drop _merge \ sort year 

reshape long mtr atr_median atr suits_split suits_adj gini_adj gini_split gini_adjpt gini_splitpt gini_w gini_wpt sg125_ sg15_ sg25_ sg35_ sg125pt_ sg15pt_ sg25pt_ sg35pt_, i(year) j(state_soi)
gen str2 stcode="."
for @ in any AL AK AZ AR CA CO CT DE DC FL GA HI ID IL IN IA KS KY LA ME MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND OH OK OR PA RI SC SD TN TX UT VT VA WA WV WI WY \ # in num 1/51: replace stcode="@" if state_soi==# 
* Musgrave-Thin, Pechman-Okner, Reynolds-Smolensky
for any adj split w: gen mt_X=(1-gini_Xpt)/(1-gini_X) \ gen po_X=(gini_Xpt-gini_X)/gini_X \ gen reynolds_X=gini_Xpt-gini_X \ gen redist_X=gini_X-gini_Xpt
ren redist_w redist
for any 125 15 25 35: gen mt_X=(1-sgXpt_)/(1-sgX_) \ gen po_X=(sgXpt_-sgX_)/sgX_ \ gen reynolds_X=sgXpt_-sgX_ \ gen redist_X=sgX_-sgXpt_
keep atr* mtr* redist* mt* po* reynolds* suits* stcode year
sort stcode year
save stateineq90sim.dta, replace

for num 1977: use cps_ineqX.dta, clear
for num 1978/2002: merge year using cps_ineqX.dta \ drop _merge \ sort year
label drop _state
label define _state 11 ME 12 NH 13 VT 14 MA 15 RI 16 CT 21 NY 22 NJ 23 PA 31 OH 32 IN 33 IL 34 MI 35 WI 41 MN 42 IA 43 MO 44 ND 45 SD 46 NE 47 KS 51 DE 52 MD 53 DC 54 VA 55 WV 56 NC 57 SC 58 GA 59 FL 61 KY 62 TN 63 AL 64 MS 71 AR 72 LA 73 OK 74 TX 81 MT 82 ID 83 WY 84 CO 85 NM 86 AZ 87 UT 88 NV 91 WA 92 OR 93 CA 94 AK 95 HI
label values state _state
decode state, gen(stcode)
sort stcode year
merge stcode year using stateineq90sim.dta
drop _merge
tab year 
sum gini*
gen stfips=.

for @ in any AK AL AR AZ CA CO CT DC DE FL GA HI IA ID IL IN KS KY LA MA MD ME MI MN MO MS MT NC ND NE NH NJ NM NV NY OH OK OR PA RI SC SD TN TX UT VA VT WA WI WV WY \ # in num 02 01 05 04 06 08 09 11 10 12 13 15 19 16 17 18 20 21 22 25 24 23 26 27 29 28 30 37 38 31 33 34 35 32 36 39 40 41 42 44 45 46 47 48 49 51 50 53 55 54 56: replace stfips=# if stcode=="@"
sort stcode
merge stcode using statenumbers
drop _merge
ren stfips statefip
sort statefip year
merge statefip year using mobility2.dta
drop _merge
sort statefip year
merge statefip year using persinc.dta, keep(persinc_percap)
drop _merge
replace persinc=ln(persinc)
ren statefip stfips
sort stfips year
merge stfips year using stateec_u.dta, keep(pop_noninstitutional unemploymentrate)
drop _merge
replace pop_noninstitutional=ln(pop_noninstitutional)
gen wagemoverratio=wagemover/wagehr
replace wagemover=ln(wagemover)
replace wagemover=. if year==1994 | year==1984 | year<1980
tsset stfips year
la var redist "Tax redistribution (GB - GA)"
la var year "Year"
la var atr "Average tax rate"
gen k=redist*((1-atr)/atr)
la var k "Kakwani progressivity measure"
la var gini "Gini"
drop if state==. | year<1977
gen eitcstate=1 if stcode=="CO" | stcode=="DC" | stcode=="IL" | stcode=="IA" | stcode=="KS" | stcode=="ME" | stcode=="MD" | stcode=="MA" | stcode=="MN" | stcode=="NJ" | stcode=="NY" | stcode=="OK" | stcode=="OR" | stcode=="RI" | stcode=="VT" | stcode=="WI"
gen redist_ma3=(redist+l.redist+l2.redist)/3
gen redist_ma6=(redist+l.redist+l2.redist+l3.redist+l4.redist+l5.redist)/6
gen redist_ma9=(redist+l.redist+l2.redist+l3.redist+l4.redist+l5.redist+l6.redist+l7.redist+l8.redist)/9

sort stcode year
merge stcode year using temp_other_state_taxes
tab _merge
drop _merge

sort state year
merge state year using temp_unionization, nokeep
tab _merge
drop _merge

* Turn unemployment rate into a 0/1 variable
replace unemploymentrate=unemploymentrate/100

tsset stfips year

save stateineq90_cps.dta, replace